"use client";
import React, { useState, useEffect } from 'react';
import Sidebar from '@/app/Components/Home/Sidebar';
import Header from '@/app/Components/Home/Header';
import { useSelector } from 'react-redux';
import { getCookie } from 'cookies-next';
import swal from 'sweetalert';
import apiRequest from '@/app/lib/InterceptorAxios/axios';
import { generatePassword } from '@/app/utils/generatePassword';
import { FaKey, FaEye, FaEyeSlash } from "react-icons/fa";
import AutoReplyModel from '@/app/(dashboard)/components/AutoReplyModel';
const roleMapping = {
  3: 'Sales',
  2: 'Admin',
  4: 'Marketing',
  
};

// Invert the roleMapping object
const roleNameToIdMapping = Object.fromEntries(
  Object.entries(roleMapping).map(([id, name]) => [name, Number(id)])
);
 
// Function to get role_id from role_name
const getRoleIdFromName = (roleName) => {
  return roleNameToIdMapping[roleName];
};

const fetchUsers = async (brandId) => {
  try {
    const response = await apiRequest(
      `/api/users/brand/${brandId}`, // Relative URL
      "GET"
    );

    return response; // Return the decrypted response data
  } catch (err) {
    console.error("Failed to fetch users:", err.message);
    throw new Error('Failed to fetch users');
  }
};


const UserPage = ({ params }) => {
  const { brandId, companyid } = params;
  const [users, setUsers] = useState([]);
  const [modalOpen, setModalOpen] = useState(false);
  const [AutoReplyOpenModel, setAutoReplyOpenModel] = useState(false);
  const [widgetScriptPath, setWidgetScriptPath] = useState('');
  const [widgetExists, setWidgetExists] = useState(false);
  const [companyName, setCompanyName] = useState('');
  const [Brand, setBrand] = useState();
  const token = getCookie('token');
  const user = useSelector((state) => state.user.userInfo);
  const [passwordVisible, setPasswordVisible] = useState(false)
  const [formData, setFormData] = useState({
    company_id: companyid,
   brand_id: brandId,
    name: '',
    pseudonym: '',
    email: '',
    password: '',
    status: '',
    designation: '',
    role_name: '',
    canCreateUsers: 0,
    canCreateBrand: 0,
      hrm_id:''
  });
  useEffect(() => {
    // Retrieve company data from sessionStorage
    const data = sessionStorage.getItem('companyData');
    
    if (data && JSON.parse(data).comp_id ==  companyid) {
      setCompanyName(JSON.parse(data).name);
    }
  }, []);
  const fetchWidget = async (brandId) => {
    try {
      const response = await apiRequest(
        "/api/script/widget", // Relative URL
        "POST",
        { brandId } // Request body
      );
  
      return response; // Return the decrypted response data
    } catch (err) {
      console.error("Failed to fetch widget:", err.message);
      throw new Error('Failed to fetch widget');
    }
  };
  useEffect(() => {
    // Construct the URL using environment variable and dynamic brand ID
    const fetchBrand = async () => {
      try {
        const data = await apiRequest(`/api/brands/${brandId}`);
       
        setBrand(data);
      } catch (error) {
        console.error("Error fetching brand data:", error);
      }
    };

    fetchBrand();
  }, [brandId]);
  useEffect(() => {

    const fetchData = async () => {
      // Fetch users
      try {
        const usersData = await fetchUsers(brandId);
       
        setUsers(usersData);
      } catch (error) {
        console.error("Error fetching users:", error.message);
        // Optionally reset users state in case of failure
        setUsers([]);
      }
  
      // Fetch widget data
      try {
        const widgetData = await fetchWidget(brandId);
  
        if (widgetData.length > 0) {
          setWidgetScriptPath(widgetData[0].file_path);
          setWidgetExists(true);
        } else {
          setWidgetExists(false);
        }
      } catch (error) {
        console.error("Error fetching widget data:", error.message);
        // Optionally reset widget state in case of failure
        setWidgetExists(false);
      }
    };
  
    fetchData();
  }, [brandId]);
  
  
  const handleModalClose = () => {
    setModalOpen(false);
    fetchUsers(brandId).then((usersData) => setUsers(usersData));
  };

  const handleChange = (e) => {
    const { name, value } = e.target;

    setFormData({
      ...formData,
      [name]: name === "brand_id" ? parseInt(value, 10) : value, // Convert brandid to integer
    });
    
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    const role = getRoleIdFromName(formData.role_name);
    if (role === undefined) {
      alert('Invalid role selected');
      return;
    }
    const created_by = user.userId;
  
    try {
      const response = await apiRequest(
        "/api/users", // Relative URL
        "POST",
        { ...formData, role, created_by } // Request body
      );
  
      // Reset form data and close modal
      setFormData({
        company_id: companyid,
        brand_id: brandId,
        name: '',
        pseudonym: '',
        email: '',
        password: '',
        status: 1,
        role_name: '',
        designation: '',
        canCreateUsers: 0,
        canCreateBrand: 0,
        hrm_id: '',
      });
      setModalOpen(false);
  
      // Fetch updated users list
      const usersData = await fetchUsers(brandId);
      setUsers(usersData);
    } catch (error) {
      console.error('Error:', error);
      alert('An error occurred');
    }
  };

  const handleCopyScript = async () => {
    if (widgetScriptPath.length > 0) {
      const script = `<script async src="${process.env.NEXT_PUBLIC_API_URL2}${widgetScriptPath}"></script>`;

      try {
        // Attempt to use the Clipboard API
        await navigator.clipboard.writeText(script);
        
        swal("Success!", "Script copied to clipboard!", "success");
      } catch (err) {
        console.error(
          "Failed to copy using Clipboard API, trying fallback:",
          err
        );

        // Fallback method using a temporary textarea
        const tempTextArea = document.createElement("textarea");
        tempTextArea.value = script;
        document.body.appendChild(tempTextArea);
        tempTextArea.select();

        try {
          const successful = document.execCommand("copy");
          if (successful) {
            
            swal("Success!", "Script copied to clipboard!", "success");
          } else {
            // alert("copy failed.");
            swal("Error", "Copy Failed", "error");
          }
        } catch (fallbackErr) {
          console.error("Fallback copy error:", fallbackErr);
          swal("Error", "Copy Failed", "error");
        } finally {
          document.body.removeChild(tempTextArea); // Clean up
        }
      }
    } else {
 
      swal("Error", "No script available to copy.", "error");
    }
  };


  const handleGenerateScript = async () => {
    try {
      const res = await fetch(`${process.env.NEXT_PUBLIC_API_URL2}/api/generate-widget`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ brandId, companyId:companyid }),
      });

      if (res.ok) {
        const widgetData = await res.json();
        setWidgetScriptPath(widgetData.filePath);
        setWidgetExists(true);
        alert('Widget created successfully!');
      } else {
        alert('Error creating widget');
      }
    } catch (error) {
      console.error('Error creating widget:', error.message);
    }
  };

  return (
    <>
   
        <div className="container-fluid top-bar d-flex justify-content-between">
          <div className="left-div">
          <h2>{Brand?.name}: Users</h2>
          </div>
          <div className="right-div left-div">
            {
              companyName &&
              <h2>Company: {companyName}</h2>

            }
          </div>
        </div>
        <div className="container-fluid company-header">
          <div className="comp-header-row">
          {widgetExists ? (
              <button className="btn" onClick={handleCopyScript}>Copy Script</button>
            ) : (
              <button className="btn" onClick={handleGenerateScript}>Generate Script</button>
            )}
            <button className="btn ms-3" onClick={() => setAutoReplyOpenModel(true)}>Auto Replies</button>
            <button className="btn ms-3" onClick={() => setModalOpen(true)}>Add User</button>
            
          </div>
        </div>
        <div className="container-fluid">
          <table className="table table-striped mt-4">
            <thead>
              <tr>
                <th>Real Name</th>
                <th>Pseudonym</th>
                <th>Designation</th>
                <th>Email</th>
                <th>Role</th>
                <th>Created At</th>
                <th>Status</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              {users.length === 0 ? (
                <tr>
                  <td colSpan="7">No Record found</td>
                </tr>
              ) : (
                users.map((user) => (
                  <tr key={user.id}>
                    <td>{user.name}</td>
                    <td>{user.pseudonym}</td>
                    <td>{user.designation}</td>
                    <td>{user.email}</td>
                    <td>{roleMapping[user.role_id] || 'Unknown'}</td>
                    <td>{new Date(user.created_at).toLocaleDateString()}</td>
                    <td>{user.status === 1 ? 'Active' : 'Inactive'}</td>
                    <td>
                      {/* Add actions here if needed */}
                    </td>
                  </tr>
                ))
              )}
            </tbody>
          </table>
        </div>
        {modalOpen && (
            <div className="modal-overlay-comp">
            <div className="modal-brand">
              <div className="modal-header-comp">
                <h5 className="modal-title">Add User</h5>
                <button
                  type="button"
                  className="modal-close"
                  onClick={() => setModalOpen(false)}
                >
                  &times;
                </button>
              </div>
              <div className="modal-body">
                <form onSubmit={handleSubmit}>
                  <div className="form-group-row-2">
                    <div className="form-group">
                      <label htmlFor="name">Real Name:</label>
                      <input
                        className="form-control"
                        type="text"
                        id="name"
                        name="name"
                        value={formData.name}
                        onChange={handleChange}
                        required
                      />
                    </div>
                    <div className="form-group">
                      <label htmlFor="pseudonym">Pseudonym:</label>
                      <input
                        className="form-control"
                        type="text"
                        id="pseudonym"
                        name="pseudonym"
                        value={formData.pseudonym}
                        onChange={handleChange}
                        required
                      />
                    </div>
                  </div>
                  <div className="form-group-row-2">
                    <div className="form-group">
                      <label htmlFor="email">Email:</label>
                      <input
                        className="form-control"
                        type="email"
                        id="email"
                        name="email"
                        value={formData.email}
                        onChange={handleChange}
                        required
                      />
                    </div>
                    <div className="form-group">
              <label htmlFor="password">Password:</label>
              <div className="password-input-container" style={{ position: "relative" }}>
                <input
                  className="form-control"
                  type={passwordVisible ? "text" : "password"}
                  id="password"
                  name="password"
                  value={formData.password}
                  onChange={handleChange}
                  required
                />
                <button
                  type="button"
                  onClick={() =>
                    setFormData({ ...formData, password: generatePassword() })
                  }
                  className="generate-password-btn"
                  style={{
                    position: "absolute",
                    right: "40px",
                    top: "50%",
                    transform: "translateY(-50%)",
                    border: "none",
                    background: "transparent",
                    cursor: "pointer",
                  }}
                  title="Generate Password"
                >
                  <FaKey size={14} color="gray" />
                </button>
                <button
                  type="button"
                  onClick={() => setPasswordVisible(!passwordVisible)}
                  className="toggle-password-btn"
                  style={{
                    position: "absolute",
                    right: "0px",
                    top: "50%",
                    transform: "translateY(-50%)",
                    border: "none",
                    background: "transparent",
                    cursor: "pointer",
                  }}
                  title={passwordVisible ? "Hide Password" : "Show Password"}
                >
                  {passwordVisible ? (
                    <FaEyeSlash size={14} color="gray" />
                  ) : (
                    <FaEye size={14} color="gray" />
                  )}
                </button>
              </div>
            </div>
                  </div>
                  <div className="form-group-row-2">

                 
                  <div className="form-group">
                    <label htmlFor="designation">HRM ID:</label>
                    <input
                      type="text"
                      className="form-control"
                      id="hrm_id"
                      name="hrm_id"
                      value={formData.hrm_id}
                      onChange={handleChange}
                      required
                    />
                  </div>
                  <div className="form-group">
                    <label htmlFor="designation">Designation:</label>
                    <input
                      type="text"
                      className="form-control"
                      id="designation"
                      name="designation"
                      value={formData.designation}
                      onChange={handleChange}
                      required
                    />
                  </div>
                  </div>
                  <div className="form-group-row-2">

            
                  <div className="form-group flex-1">
                    <label htmlFor="status">Status:</label>
                    <select
                      className="form-control"
                      id="status"
                      name="status"
                      value={formData.status}
                      onChange={handleChange}
                      required
                    >
                      <option value="">Select a status</option>
                      <option value="1">Active</option>
                      <option value="0">Inactive</option>
                    </select>
                  </div>
                  <div className="form-group flex-1">
                    <label htmlFor="role_name">Role:</label>
                    <select
                      className="form-control"
                      id="role_name"
                      name="role_name"
                      value={formData.role_name}
                      onChange={handleChange}
                      required
                    >
                      <option value="">Select a role</option>
                    
                      <option value="Admin">Admin</option>
                      <option value="Sales" selected>Sales</option>
                      <option value="Marketing">Marketing</option>
                    
                    </select>
                  </div>
                  </div>
                  <div className="form-group-row-2">
                  <div className="form-group flex-1">
                  <label htmlFor="canCreateUsers">Can Create Users</label>
                  <select
                    className="form-control"
                    id="canCreateUsers"
                    name="canCreateUsers"
                    value={formData.canCreateUsers}
                    onChange={handleChange}
                    required
                  >
                    <option value={0}>No</option>
                    <option value={1}>Yes</option>
                  </select>
                </div>
                <div className="form-group flex-1">
                  <label htmlFor="canCreateBrand">Can Create Brand</label>
                  <select
                    className="form-control"
                    id="canCreateBrand"
                    name="canCreateBrand"
                    value={formData.canCreateBrand}
                    onChange={handleChange}
                    required
                  >
                    <option value={0}>No</option>
                    <option value={1}>Yes</option>
                  </select>
                </div>
                </div>
                  <button type="submit" className="btn submit-btn p-btn mt-3 w-100">
                    Submit
                  </button>
                </form>
              </div>
            </div>
          </div>
        )}
        {AutoReplyOpenModel && (
        <AutoReplyModel brandId = {brandId} AutoReplyOpenModel= {AutoReplyOpenModel} setAutoReplyOpenModel= {setAutoReplyOpenModel}/>        
        )}
   
    </>
  );
};

export default UserPage;


 